//////////////////  sciprefit-77 ///////////////////
clear;     // clear workspace and system memory
   clc();  // clear console window
   clf();  // clear figure-windows
//  
mprintf('\n \n');
mprintf(' ==========   sciprefit-77   ==========\n');
mprintf(' ==  Program for Ideal vector model  ==\n');
mprintf(' ==       Scilab version of          ==\n');
mprintf(' ==  preference regression analysis  ==\n');
mprintf(' ==  Author :    S. Kido (2013.11.11)==\n');
mprintf(' ======================================\n');
//
// Input data
//
//coordinates of coorporates (MDS output of image data )
data=[
  -0.05238,   0.04371;
   0.16407,  -0.02883;
   0.07227,   0.04021;
  -0.03019,  -0.04808;
  -0.08161,  -0.00432;
   0.00774,   0.00078;
   0.02944,  -0.03184;
   0.01334,   0.03106;
  -0.03394,  -0.04346;
  -0.15655,   0.06397;
  -0.00190,  -0.03025];
// labels of coorporates(brands) 
  lab=["Ka","Ms","Nt","Pg","Sn","Ht","Fz","Ot","Ks","Cc","Sd"];
  ranking=[1,8,4,10,2,9,11,5,7,3,6] ;//preference ranking
  pref=11-ranking; //make preference score  by reversed ranking
//
[m n] = size(data); //Size of original X matrix
//
mprintf('\n \n');
mprintf('Table of Input Data\n');
mprintf('--------------------------------------------------------- \n');
mprintf(' i    Label      y(i)           X(1)         X(2)    \n');
mprintf('--------------------------------------------------------- \n');
for i = 1:m
mprintf('%3.0f   %s     %10.6f     %10.6f   %10.6f   \n',...
          i,    lab(i),  pref(i), data(i,1),data(i,2));
end;
mprintf('--------------------------------------------------------- \n');
mprintf('\n\n');
//
// ploting
//
   scf(0);
// set max value 
   x_max =max(data)+0.01 ;
   x_min =min(data)-0.01 ; 
   //   x_max =ceil(max(data))+0.01;      
   //   x_min =ceil(min(data))-0.01; 
//----------------------------------------------------
        plot2d([ x_min ; x_max],[ x_min ; x_max],0);
         xset("font size",3); 
  xtitle ('Stimuli-Plot','X axis','Y axis');//xgrid(2);//blue grid
//----------------------------------------------------
  for i = 1 : m      
       cx(i)=data(i,1);
       cy(i)=data(i,2);
   end //i
   for i=1:m
      xstring(cx(i),cy(i),lab(i));           // label
    //   xstring(cx(i),cy(i),ascii(64 + i));//64 for alpabet ABC
   // xstring(cx(i),cy(i),ascii(48 + i));     //48 for nueric 123
   end
//endfunction
//
// regression analysis
//
XA=data;
y=pref;
y=y';
//
// Statistics
//
[m n] = size(XA); //Size of original X matrix
X = [ones(m,1) XA]; //Augmenting matrix X
b=inv(X'*X)*X'*y; //Coefficients of function
yh = X*b; //Fitted value of y
e=y-yh; //Errors or residuals
SSE=e'*e; //Sum of squared errors
MSE = SSE/(m-n-1); //Mean square error
se = sqrt(MSE); //Standard error of estimate
C = MSE*inv(X'*X); //Covariance matrix
[nC mC]=size(C);
seb = []; //Standard errors for coefficients
for i = 1:nC
seb = [seb; sqrt(C(i,i))];
end;
//***********
alpha=0.1;
//***********
ta2 = cdft('T',m-n,1-alpha/2,alpha/2); //t_alpha/2
sY = []; sYp = []; //Terms involved in C.I. for Y, Ypred
for i=1:m
sY = [sY; sqrt(X(i,:)*C*X(i,:)')];
sYp = [sYp; se*sqrt(1+X(i,:)*(C/se)*X(i,:)')];
end;
CIYL = yh-sY; //Lower limit for C.I. for mean Y
CIYU = yh+sY; //Upper limit for C.I. for mean Y
CIYpL = yh-sYp; //Lower limit for C.I. for predicted Y
CIYpU = yh+sYp; //Upper limit for C.I. for predicted Y
CIbL = b-ta2*seb; //Lower limit for C.I. for coefficients
CIbU = b+ta2*seb; //Upper limit for C.I. for coefficients
t0b = b./seb; //t parameter for testing H0:b(i)=0
decision = []; //Hypothesis testing for H0:b(i)=0
for i = 1:n+1
 if t0b(i)>ta2 | t0b(i)<-ta2 then
   decision = [decision; ' reject '];
  else
      decision = [decision; ' do not reject'];
 end;
end;
ybar = mean(y); //Mean value of y
xbar = mean(XA)
SST = sum((y-ybar)^2); //Total sum of squares
SSR = sum((yh-ybar)^2); //Residual sum of squares
MSR = SSR/n; //Regression mean square
MSE = SSE/(m-n-1); //Error mean square
F0 = MSR/MSE; //F parameter for significance of regression
Fa = cdff('F',n,m-n-1,1-alpha,alpha); //F_alpha
R2 = 1-SSE/SST; R = sqrt(R2); //Coeff. of multiple regression
R2a = 1-(SSE/(m-n-1))/(SST/(m-1)); //Adj. Coeff. of multiple regression
//compute standarized coefficients
StdDevX=[];B=[];bb=[];xbar=[];
VarY = variance(y);
StdDevY=sqrt(VarY);              //standard deviation of input data y
  for i = 1:n
    bb(i)=b(i+1);
      xbar(i) = mean(XA(:,i));
      VarX(i) = variance(XA(:,i)); //variance
     StdDevX(i)=sqrt(VarX(i)); //standard deviation of input data x
    B(i)=bb(i)*(StdDevX(i)/StdDevY);   // standarized coefficients
  end
//
//Output of results
//
mprintf('\n');
mprintf('============================\n');
mprintf(' Multiple Linear Regression');mprintf('\n');
mprintf('============================\n');mprintf('\n');
i=1;
mprintf('Table of Statistics\n');
mprintf('---------------------------------------------------\n');   
mprintf('   X     N     Mean          Std.Dev.    Variance  \n')
mprintf('---------------------------------------------------\n');
mprintf('%4.0f %5.0f  %10.5f    %10.5f  %10.5f\n',i-1,m,ybar,StdDevY,VarY);
for i = 1:n 
mprintf('%4.0f %5.0f  %10.5f    %10.5f  %10.5f\n',i,m,xbar(i),StdDevX(i),VarX(i));
end
mprintf('----------------------------------------------------\n');
mprintf('(Note) dependent variable y: X0 \n')
mprintf('\n');
mprintf('Table of coefficients');mprintf('\n');
mprintf('-------------------------------------------------------------...
-------------');mprintf('\n');
mprintf('   X     b(i)       se(b(i))   Lower      Upper      t0      H0:b(i)=0 \n');
mprintf('--------------------------------------------------------------...
------------');mprintf('\n');
for i = 1:n+1
mprintf('%4.0f %10g %10g %10g %10g %10g %s',...
i-1,b(i),seb(i),CIbL(i),CIbU(i),t0b(i),decision(i));mprintf('\n');
end;
mprintf('---------------------------------------------------------------...
-----------');mprintf('\n');
mprintf('(Note) dependent variable y: X0          t_alpha/2 = %g',ta2);mprintf('\n');
mprintf('----------------------------------------------------------------...
----------\n');mprintf('\n');
//
mprintf('\n');i=1;
mprintf('Table of standarized coefficients B(i) \n');
mprintf('------------------------------------\n');
mprintf('   X     b(i)       B(i)  \n');
mprintf('------------------------------------\n');
mprintf('%4.0f %10g    \n',i-1,b(1));
for i = 1:n
mprintf('%4.0f %10g %10g   \n',i,bb(i),B(i));
end;
mprintf('------------------------------------\n');mprintf('\n');
//
mprintf('Table of fitted values and errors\n');
mprintf('---------------------------------------------------------------------------------\n');
mprintf(' i         y(i)      yh(i)      e(i)       C.I. for Y           C.I.for Ypred\n');
mprintf('---------------------------------------------------------------------------------\n');
for i = 1:m
mprintf('%4.0f %10.6g %10.6g %10.6g %10.6g %10.6g %10.6g %10.6g\n',...
i,y(i),yh(i),e(i),CIYL(i),CIYU(i),CIYpL(i),CIYpU(i));
end;
mprintf('---------------------------------------------------------------------------------\n');
mprintf('\n');mprintf('\n');
mprintf('Analysis of variance\n');
mprintf('---------------------------------------------------------------\n');
mprintf('Source of      Sum of    Degrees of      Mean\n')
mprintf('variation      squares      freedom     square       F0\n');
mprintf('---------------------------------------------------------------\n');
mprintf('Regression %10.6f %10.0f     %10.6f   %10.6f\n',SSR,n,MSR,F0');
mprintf('Residual   %10.6f %10.0f     %10.6f \n',SSE,m-n-1,MSE);
mprintf('Total      %10.6f %10.0f \n',SST,m-1);
mprintf('---------------------------------------------------------------\n');
mprintf('With F0 = %g and F_alpha = %g,\n',F0,Fa);
if F0>Fa then
mprintf('reject the null hypothesis H0:beta1=beta2=...=betan=0.\n');
else
mprintf('do not reject the null hypothesis H0:beta1=beta2=...=betan=0.\n');
end;
mprintf('---------------------------------------------------------------\n');
disp(' ');
mprintf('Model fitness information\n');
mprintf('-----------------------------------------------------------\n');
mprintf('Standard error of estimate (se)                = %g\n',se);
mprintf('Coefficient of multiple determination (R^2)    = %g\n',R2);
mprintf('Multiple correlation coefficient (R)           = %g\n',R);
mprintf('Adjusted coefficient of multiple determination = %g\n',R2a);
mprintf('-----------------------------------------------------------\n');
mprintf('\n');
//
// Draw arrow-line color="red", maker= >)
//
xpts = [0 B(1)]; //standarized coef.
ypts = [0 B(2)];
//xpts = [0 -b(2)]; //invert to minus sign in case of original rank 
//ypts = [0 b(3)];
//'r-.diam'
//plot(xpts, ypts,'r-<' );
plot(xpts, ypts,'r->');
//end
